casper.start();
casper.test.comment('Set a custom icon for one of the built-in menus.');

ameTest.thenQuickSetup();

casper.then(function() {
	ameTest.loadDefaultMenu();
	ameTest.selectItemByTitle('Media', null, true);
	casper.click('.ws_menu.ws_active .ws_toggle_advanced_fields');
	ameTest.setItemFields({
		'icon_url': 'images/loading.gif' //Change to something more appropriate if I ever add custom icons to AME.
	});
	casper.click('#ws_save_menu');
});

casper.waitForSelector('#message.updated', function() {
	casper.test.assertExists('#menu-media', 'The "Media" menu exists');
	casper.test.assertDoesntExist('#menu-media.menu-icon-media', "The default icon class has been removed");
	casper.test.assertExists(
		'#menu-media .wp-menu-image img[src="images/loading.gif"]',
		"The custom icon exists and has the right URL"
	);
});

casper.then(function() {
	casper.test.comment('Test the icon selector widget');

	ameTest.selectItemByTitle('Media', null, true);
	casper.click('.ws_menu.ws_active .ws_toggle_advanced_fields');

	casper.click('.ws_menu.ws_active .ws_select_icon');
	casper.test.assertVisible('#ws_icon_selector', 'Clicking the icon button displays the icon selector');

	casper.test.assertEvalEquals(
		function() {
			return jQuery('#ws_icon_selector').find('.ws_selected_icon').data('icon-url');
		},
		'images/loading.gif',
		'The custom icon is marked as selected'
	);

	//Change the icon of the "Media" menu to the built-in "Tools" icon.
	casper.click('#ws_icon_selector .ws_icon_option[data-icon-url="dashicons-admin-tools"]');
	casper.test.assertEval(function() {
		return !jQuery('#ws_icon_selector').is(':visible');
	}, 'Clicking one of the available icons hides the icon selector');

	casper.click('.ws_menu.ws_active .ws_select_icon');
	casper.test.assertEvalEquals(
		function() {
			return jQuery('#ws_icon_selector').find('.ws_selected_icon').data('icon-url');
		},
		'dashicons-admin-tools',
		'The clicked icon is correctly marked as selected'
	);

	casper.click('#ws_save_menu');
});

casper.waitForSelector('#message.updated', function() {
	casper.test.assertExists(
		'#menu-media .wp-menu-image.dashicons-admin-tools',
		'The menu icon class was successfully changed using the icon selector'
	);
	casper.test.assertDoesntExist(
		'#menu-media .wp-menu-image img',
		'Selecting an icon class removes the custom icon URL (if any)'
	);
});

casper.then(function() {
	casper.test.comment('Test Dashicons and the More/Less button');

	ameTest.selectItemByTitle('Posts', null, true);
	casper.click('.ws_menu.ws_active .ws_toggle_advanced_fields');
	casper.click('.ws_menu.ws_active .ws_select_icon');

	casper.test.assertNotVisible(
		'#ws_icon_selector .ws_icon_option.ws_icon_extra',
		'Extra menu icons start out invisible.'
	);

	casper.click('#ws_show_more_icons');
	casper.test.assertVisible(
		'#ws_icon_selector .ws_icon_option.ws_icon_extra',
		'Clicking "More" reveals extra icons.'
	);

	//Select the "Search" dashicon.
	casper.click('#ws_icon_selector .ws_icon_option[data-icon-url="dashicons-search"]');

	casper.click('#ws_save_menu');
});

casper.waitForSelector('#message.updated', function() {
	casper.test.assertExists(
		'#menu-posts .wp-menu-image.dashicons-search',
		'The menu icon was successfully changed to a Dashicon using the icon selector'
	);
});

casper.then(function() {
	casper.test.comment('Give a submenu item a custom icon.');

	//By default, submenus are set to "only show icons when manually selected". So they start out with no icons.
	casper.test.assertDoesntExist(
		'#adminmenu ul.wp-submenu .dashicons',
		"By default, submenus don't have Dashicons"
	);
	casper.test.assertDoesntExist(
		'#adminmenu ul.wp-submenu .ame-submenu-icon',
		"By default, submenus don't have .ame-submenu-icon's"
	);

	//Give a submenu one of the default icons.
	ameTest.selectItemByTitle('Settings', 'Writing', true);
	casper.click('.ws_item.ws_active .ws_toggle_advanced_fields');

	ameTest.setItemFields(
		{
			'icon_url': 'dashicons-star-empty'
		},
		'submenu'
	);

	casper.click('#ws_save_menu');
});

casper.waitForSelector('#message.updated', function() {
	casper.test.assertExists(
		'#menu-settings ul.wp-submenu a[href="options-writing.php"] .dashicons-star-empty',
		'Custom submenu icons show up correctly'
	);
});

casper.then(function() {
	casper.test.comment('Change submenu icon visibility to "always".');
	casper.click('#ws_plugin_settings_button');
});

//Select the "Show submenu icons": "Always" option and save changes.
casper.waitForSelector('#ws_plugin_settings_form', function() {
	casper.click('input[name="submenu_icons_enabled"][value="always"]');
	casper.click('#submit');
});

casper.waitForSelector('div.updated', function() {
	//All submenus should have a Dashicon now.
	casper.test.assertEvalEquals(
		function() {
			var submenusWithoutIcons = jQuery('#adminmenu')
				.find('ul.wp-submenu li a')
				.filter(function() {
					return jQuery(this).find('.dashicons').length == 0
				});
			return submenusWithoutIcons.length;
		},
		0,
		'Setting "Show submenu icons" to "Always" adds icons to all submenus'
	)
});

//Select the "Show submenu icons": "Never" option and save changes.
//We're still on the settings page, so no need to navigate to it again.
casper.waitForSelector('#ws_plugin_settings_form', function() {
	casper.test.comment('Change submenu icon visibility to "never".');
	casper.click('input[name="submenu_icons_enabled"][value="never"]');
	casper.click('#submit');
});

casper.waitForSelector('div.updated', function() {
	//No submenu icons should be visible now. Even the custom icon we set for Settings -> Writing should be gone.
	casper.test.assertDoesntExist(
		'#adminmenu ul.wp-submenu li a .dashicons',
		'Setting "Show submenu icons" to "Never" hides all submenu Dashicons'
	);
	casper.test.assertDoesntExist(
		'#adminmenu ul.wp-submenu li a .ame-submenu-icon',
		'Setting "Show submenu icons" to "Never" hides all .ame-submenu-icon\'s'
	);
});

casper.run(function() {
    this.test.done();
});